﻿var originalAttributes = {};

function handleButtonClick()
{
    let loadNextPageElement = document.getElementById("loadnextpage");

    let buttonElement = document.querySelector("[id$='loadNext']");

    saveAttributes(buttonElement);
    //buttonElement.disabled = true;
    //disablebutton(buttonElement)
    disableButton(buttonElement, true);

    const currentUrlParams = new URLSearchParams(window.location.search);
    const page = currentUrlParams.get('page') || 1;
    const params = {
        page: page || '',
        FullText: currentUrlParams.get('FullText') || ''
    };
    if (params.page === '1') {
        appendQueryParameter('1');
        const url = new URL(window.location.href);
        url.searchParams.set('page', '1');
        window.history.pushState({ path: url.toString() }, '', url.toString());
    }

    fetch(QIPortalAPI.appPath + 'LoadNextPage?' + QIShop.prepareAjaxQS(page), {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(params)
    })
        .then(response =>
        {
            const lastPage = parseInt(response.headers.get('X-Last-Page'));
            let loadNextPageElement = document.getElementById("loadnextpage");

            if (loadNextPageElement)
            {
                //let customAttributeValue = loadNextPageElement.getAttribute('data-lastloadedpage');
                let maxRange = parseInt(loadNextPageElement.getAttribute('data-maxrange'));

                const currentUrlParams = new URLSearchParams(window.location.search);
                const rawPageParam = currentUrlParams.get('page') || '';

                let currentDispPage;
                if (rawPageParam.includes('-'))
                {
                    const [start, end] = rawPageParam.split('-').map(Number);
                    currentDispPage = end - start + 1;
                }
                else
                {
                    currentDispPage = 1;
                }

                if (currentDispPage < maxRange)
                {
                    updatePageQueryParam(lastPage);
                    return response.text();
                }
                else
                {
                    return Promise.reject('Max range reached or last page already loaded.');
                }
            }
            else
            {
                updatePageQueryParam(lastPage);
                return response.text();
            }
        })
        .then(data =>
        {
            if (!data) return;

            const inputdata = data;
            let commentNode = findCommentNodeWithText(document.body, "LoadNextPageComment");

            if (commentNode)
            {
                if (commentNode.parentNode.firstChild === commentNode)
                {
                    commentNode.parentNode.insertAdjacentHTML('afterbegin', inputdata);
                }
                else
                {
                    let previousElementSibling = commentNode.previousSibling;
                    while (previousElementSibling && previousElementSibling.nodeType !== Node.ELEMENT_NODE)
                    {
                        previousElementSibling = previousElementSibling.previousSibling;
                    }
                    if (previousElementSibling)
                    {
                        previousElementSibling.insertAdjacentHTML('afterend', inputdata);
                    }
                    else
                    {
                        commentNode.parentNode.insertAdjacentHTML('afterbegin', inputdata);
                    }
                }

            }
            buttonElement.disabled = false;
            disableButton(buttonElement, false)
            checkAndDisableButtonIfNeeded();
        })
        .catch(error => {
            console.error('Error:', error);
            buttonElement.disabled = false;
            disableButton(buttonElement, false)
        });
    return false;
}

window.addEventListener('load', function ()
{
    let loadNextPageElement = document.getElementById("loadnextpage");

    const currentUrlParams = new URLSearchParams(window.location.search);
    const rawPageParam = currentUrlParams.get('page') || '';
    let pageparams = parsePageParam(rawPageParam);

    if (loadNextPageElement)
    {
        let customAttributeValue = loadNextPageElement.getAttribute('data-lastloadedpage');

        pageparams.end = parseInt(customAttributeValue);
        if (!pageparams.isRange)
        {
            setOrUpdateQueryParam("page", pageparams.end);
        }
        else
        {
            if (pageparams.start == null)
            {
                pageparams.start = 1;
            }
            setOrUpdateQueryParam("page", pageparams.start + "-" + pageparams.end);
        }
        checkAndDisableButtonIfNeeded();
    }
    updateNavigationClasses();
});

document.addEventListener('keydown', function (event)
{
    if (event.key === "Enter")
    {
        let focusedElement = document.activeElement;
        if (focusedElement.classList.contains('QuantityEdit'))
        {
            let parts = focusedElement.id.split('quantity_');
            let focusedId = parts[1];
            let targetId = 'cartImg_' + focusedId;

            let parentElement = focusedElement.parentElement;

            let targetSibling = null;

            for (let child of parentElement.children)
            {
                if (child.id && child.id.includes(targetId))
                {
                    targetSibling = child;
                    targetSibling.click();
                    break;
                }
            }
        }
    }
});

function findCommentNodeWithText(rootElement, searchText) {
    let walker = document.createTreeWalker(
        rootElement,
        NodeFilter.SHOW_COMMENT,
        {
            acceptNode: function (node) {
                if (node.nodeValue.includes(searchText)) {
                    return NodeFilter.FILTER_ACCEPT;
                }
                return NodeFilter.FILTER_SKIP;
            }
        }
    );

    return walker.nextNode();
}

function checkAndDisableButtonIfNeeded() {
    const loadNextPageElement = document.getElementById("loadnextpage");
    if (!loadNextPageElement) return;

    const maxrange = parseInt(loadNextPageElement.getAttribute('data-maxrange'));
    const currentUrlParams = new URLSearchParams(window.location.search);
    const rawPageParam = currentUrlParams.get('page') || '';
    const pageparams = parsePageParam(rawPageParam);

    let nextPageEnd = pageparams.isRange ? pageparams.end + 1 : (pageparams.start ? pageparams.start + 1 : 2);

    const buttonElement = document.querySelector("[id$='loadNext']");
    if (buttonElement && nextPageEnd > maxrange) {
        //buttonElement.disabled = true;
        disableButton(buttonElement, true);
    }
}

function parsePageParam(pageParam)
{
    let result = {
        isRange: false,
        start: null,
        end: null
    };

    if (pageParam.includes('-'))
    {
        let parts = pageParam.split('-');
        result.isRange = true;
        result.start = parseInt(parts[0]);
        result.end = parseInt(parts[1]);
    }
    else
    if (pageParam !== '')
    {
        result.start = parseInt(pageParam);
    }

    if (result.start == result.end)
    {
        result.isRange = false;
    }

    return result;
}

function updatePageQueryParam(lastPage)
{
    const currentUrlParams = new URLSearchParams(window.location.search);
    const rawPageParam = currentUrlParams.get('page') || '1';
    const parsedPage = parsePageParam(rawPageParam);

    if (parsedPage.isRange)
    {
        let newPageParam = `${parsedPage.start}-${lastPage}`;
        setOrUpdateQueryParam('page', newPageParam);
    }
    else
    if (parsedPage.start !== null)
    {
        const lastPageNumber = parseInt(lastPage);

        if (!isNaN(parsedPage.start) && !isNaN(lastPageNumber) && lastPageNumber > parsedPage.start)
        {
            let newPageParam = `${parsedPage.start}-${lastPageNumber}`;
            setOrUpdateQueryParam('page', newPageParam);
        }
    }
    else
    if (rawPageParam === '' && lastPage === '2')
    {
        setOrUpdateQueryParam('page', '1-2');
    }
}

function appendQueryParameter(pagenumber)
{
    const form = document.getElementById("mainForm");
    if (form)
    {
        const actionURL = new URL(form.action, window.location.origin);

        if (actionURL.searchParams.has('page'))
        {
            actionURL.searchParams.set('page', pagenumber);
        }
        else
        {
            actionURL.searchParams.append('page', pagenumber);
        }

        form.action = actionURL.href.replace(actionURL.origin, '');
    }
}

function setOrUpdateQueryParam(paramName, paramValue)
{
    const url = new URL(window.location.href);
    url.searchParams.set(paramName, paramValue);
    appendQueryParameter(paramValue);
    if (paramValue != '1' && paramName === 'page') {
        window.history.pushState({ path: url.toString() }, '', url.toString());
    }
    updateNavigationClasses();
}

function updateNavigationClasses()
{
    const pageNavigationElements = document.querySelectorAll('div.PageNavigation');
    const currentUrlParams = new URLSearchParams(window.location.search);
    const urlParams = {
        page: currentUrlParams.get('page') || '',
    };
    let flag = false;
    let classlist = null;
    const listOfPages = getListOfPages(urlParams.page);
    
    pageNavigationElements.forEach(element =>
    {

        Array.from(element.children).forEach(child =>
        {
            if (child.classList.contains("pgNav-item"))
            {
                const numberInside = child.textContent.trim();
                if (!isNaN(numberInside))
                {
                    const pageNumber = parseInt(numberInside, 10);
                    if (listOfPages.includes(pageNumber))
                    {
                        if (!flag)
                        {
                            flag = true;
                            classlist = [...child.classList];
                        }
                        child.classList.add(...classlist);
                    }
                }
            }
        });
    });
    if (urlParams.page !== '')
    {
        const currentPageElements = document.querySelectorAll('[id$="pagenumberlabel"]');
        currentPageElements.forEach(element =>
        {
            element.textContent = urlParams.page;
        });
    }
}

function getListOfPages(pageRange)
{
    if (pageRange === '')
    {
        return [1];
    }

    const pages = [];
    const parts = pageRange.split('-');
    if (parts.length === 1)
    {
        pages.push(parseInt(parts[0], 10));
    }
    else
        if (parts.length === 2)
        {
            const start = parseInt(parts[0], 10);
            const end = parseInt(parts[1], 10);
            for (let i = start; i <= end; i++)
            {
                pages.push(i);
            }
        }
    return pages;
}

function disableButton(el, action) {

    if (el.tagName === 'INPUT') {
        el.disabled = action;
    }
    else if (el.tagName === 'A') {
        if (action) {
            el.removeAttribute('onclick');
            el.removeAttribute('href');
        } else {
            el.setAttribute('onclick', originalAttributes[el.id].onclick);
            el.setAttribute('href', originalAttributes[el.id].href);
        }
    }
    else if (el.tagName === 'IMG') {
        if (action) {
            el.removeAttribute('onclick');
        } else {
            el.setAttribute('onclick', originalAttributes[el.id].onclick);
        }
    }
}

function saveAttributes(el) {
    if (el.tagName === 'A') {
        originalAttributes[el.id] = {
            onclick: el.getAttribute('onclick'),
            href: el.getAttribute('href')
        };    
    }
    else if (el.tagName === 'IMG') {
        originalAttributes[el.id] = {
            onclick: el.getAttribute('onclick'),
            href: '0'
        };
    }
}